/*
 * Decompiled with CFR 0.152.
 */
package android.device;

import android.os.IBinder;
import android.os.IScanService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class ScanDevice {
    private static final String TAG = "ScanDevice";
    private int scanType;
    private IScanService mScanService;

    public ScanDevice() {
        IScanService mService;
        Log.i((String)TAG, (String)"start scandevice on ");
        this.mScanService = mService = IScanService.Stub.asInterface((IBinder)ServiceManager.getService((String)"scan"));
    }

    public boolean setOutScanMode(int mode) {
        try {
            this.mScanService.setOutputMode(mode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    public int getOutScanMode() {
        try {
            return this.mScanService.getOutputMode();
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public boolean setScanBeep() {
        try {
            this.mScanService.setBeepMode(1);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    public boolean setScanUnBeep() {
        try {
            this.mScanService.setBeepMode(0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    public boolean getScanBeepState() {
        int state = 0;
        try {
            state = this.mScanService.getBeepMode();
            return state == 1;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean setScanVibrate() {
        try {
            this.mScanService.setVibratorMode(1);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    public boolean setScanUnVibrate() {
        try {
            this.mScanService.setVibratorMode(0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    public boolean getScanVibrateState() {
        int state = 0;
        try {
            state = this.mScanService.getVibratorMode();
            return state == 1;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean setScanCodeEnterKey() {
        try {
            this.mScanService.setEnterKeyMode(1);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    public boolean setScanCodeNoEnterKey() {
        try {
            this.mScanService.setEnterKeyMode(0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    public boolean getScanCodeEnterKeyMode() {
        int state = 0;
        try {
            state = this.mScanService.getEnterKeyMode();
            return state == 1;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean setScanOutParameter(int type, int value) {
        switch (type) {
            case 1: {
                if (value == 0) {
                    this.setScanUnBeep();
                    break;
                }
                this.setScanBeep();
                break;
            }
            case 2: {
                if (value == 0) {
                    this.setScanUnVibrate();
                    break;
                }
                this.setScanVibrate();
                break;
            }
            case 3: {
                if (value == 0) {
                    this.setScanCodeNoEnterKey();
                    break;
                }
                this.setScanCodeEnterKey();
                break;
            }
        }
        return true;
    }

    public int getScanOutParameter(int type) {
        switch (type) {
            case 1: {
                return this.getScanBeepState() ? 1 : 0;
            }
            case 2: {
                return this.getScanVibrateState() ? 1 : 0;
            }
            case 3: {
                return this.getScanCodeEnterKeyMode() ? 1 : 0;
            }
        }
        return -1;
    }

    public void setScanLaserMode(int mode) {
        try {
            this.mScanService.setLaserMode(mode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setScanLaserTime(int time) {
        try {
            this.mScanService.setLaserOnTime(time);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setScanSameCodeTimeOut(int time) {
        try {
            this.mScanService.setSameSymbolTimeOut(time);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean openScan() {
        try {
            this.mScanService.open();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    public boolean closeScan() {
        try {
            this.mScanService.close();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    public boolean isScanOpened() {
        try {
            return this.mScanService.isScannerOpen();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean stopScan() {
        try {
            return this.mScanService.stopDecode();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean startScan() {
        try {
            this.mScanService.startDecode();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public boolean scanLock() {
        try {
            this.mScanService.scanLock();
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public boolean scanUnlock() {
        try {
            this.mScanService.scanUnlock();
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public boolean getScanLockState() {
        return false;
    }

    public boolean resetScan() {
        try {
            return this.mScanService.resetScan();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static String toHexString(String s) {
        String tempstr = "";
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            String s4 = Integer.toHexString(ch);
            tempstr = tempstr + s4;
        }
        return tempstr;
    }

    public void setScannerType(int type) {
        if (type > 9 && type < 0) {
            return;
        }
        try {
            this.mScanService.setScanType(type);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getScannerType() {
        try {
            this.scanType = this.mScanService.getScannerType();
        }
        catch (RemoteException e) {
            return 0;
        }
        return this.scanType;
    }
}

